% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_experiment.R
\name{simulate_experiment}
\alias{simulate_experiment}
\alias{sim_experiment}
\alias{sim_experiment_from_data}
\title{Simulate a DECAL perturbation experiment}
\usage{
sim_experiment(
  depth,
  ratio,
  lfc = 0,
  nclones = 10L,
  min_n = 2L,
  max_n = 20L,
  theta = 100L
)

sim_experiment_from_data(
  reference,
  lfc = 0,
  nclones = 10L,
  min_n = 2L,
  max_n = 20L,
  theta = 100L,
  ngenes = NULL
)
}
\arguments{
\item{depth}{cells total UMI count}

\item{ratio}{ratio of genes UMI over total UMI count}

\item{lfc}{vector indicating the perturbations to be generated for each clone}

\item{nclones}{number of clones to be simulated}

\item{min_n}{minimum clone size}

\item{max_n}{maximum clone size}

\item{theta}{negative binomial dispersion parameter}

\item{reference}{UMI count matrix used as base for the simulation}

\item{ngenes}{number of genes to be simulated. When \code{NULL} it replicates
the gene ratio found in \code{reference}, otherwise it simulates \code{ngenes}
with ratio ranging in a logarithm scale from lowest to highest observed
ratio observed.}
}
\value{
a list containing the following fields:
\itemize{
\item \code{perturbations}, a table indicating the perturbations \code{expected_lfc} for
a \code{gene} in a \code{clone}.
\item \code{clone}, a list of cells assigned to each clone.
\item \code{count}, a random UMI count matrix.
}
}
\description{
It simulates a random DECAL experiment generating a random UMI count matrix
with cells randomly assigned to different clones and introducing to each
clone perturbations to random genes.
}
